/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.thermal;

import cofh.lib.fluid.FluidIngredient;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import dev.latvian.mods.kubejs.fluid.FluidStackJS;
import dev.latvian.mods.kubejs.item.ingredient.IngredientJS;
import dev.latvian.mods.kubejs.recipe.RecipeExceptionJS;
import dev.latvian.mods.kubejs.thermal.ThermalRecipeJS;
import dev.latvian.mods.kubejs.util.ListJS;
import java.util.ArrayList;

public class FuelRecipeJS
extends ThermalRecipeJS {
    public ArrayList<FluidIngredient> inputFluids = new ArrayList();
    public String inKey = "";

    public void create(ListJS args) {
        this.inKey = "ingredients";
        for (Object o : ListJS.orSelf((Object)args.get(0))) {
            if (o instanceof FluidStackJS) {
                this.inputFluids.add(this.fluidFrom((FluidStackJS)o));
                continue;
            }
            this.inputItems.add(this.parseIngredientItem(o));
        }
        this.json.addProperty("energy", (Number)100000);
        if (this.inputItems.isEmpty() && this.inputFluids.isEmpty()) {
            throw new RecipeExceptionJS("Thermal recipe can't have no ingredients!");
        }
    }

    public void deserialize() {
        JsonElement element;
        this.inKey = "";
        if (this.json.has("ingredient")) {
            this.inKey = "ingredient";
        } else if (this.json.has("ingredients")) {
            this.inKey = "ingredients";
        } else if (this.json.has("input")) {
            this.inKey = "input";
        } else if (this.json.has("inputs")) {
            this.inKey = "inputs";
        }
        if (!this.inKey.isEmpty() && (element = this.json.get(this.inKey)) != null) {
            JsonArray array;
            if (element.isJsonArray()) {
                array = element.getAsJsonArray();
            } else {
                array = new JsonArray();
                array.add(element);
            }
            for (JsonElement e : array) {
                if (e.isJsonObject() && (e.getAsJsonObject().has("fluid") || e.getAsJsonObject().has("fluid_tag"))) {
                    this.inputFluids.add(FluidIngredient.fromJson((JsonElement)e));
                    continue;
                }
                this.inputItems.add(this.parseIngredientItem(e));
            }
        }
    }

    public void serialize() {
        if (this.serializeInputs) {
            JsonArray in = new JsonArray();
            for (IngredientJS ingredient : this.inputItems) {
                in.add(ingredient.toJson());
            }
            for (FluidIngredient fluid : this.inputFluids) {
                in.add(fluid.toJson());
            }
            this.json.add(this.inKey, (JsonElement)in);
        }
    }
}

